/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.api.event;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import lib.toma.animations.AnimationEngine;
import lib.toma.animations.api.AnimationType;
import lib.toma.animations.api.IAnimation;
import lib.toma.animations.api.IAnimationPipeline;
import lib.toma.animations.api.event.AnimationEventType;
import lib.toma.animations.api.event.IAnimationEvent;
import lib.toma.animations.api.event.IAnimationEventSerializer;
import lib.toma.animations.api.lifecycle.Registries;
import lib.toma.animations.engine.AbstractAnimationEvent;
import lib.toma.animations.engine.screen.animator.dialog.EventCreateDialog;
import lib.toma.animations.engine.screen.animator.dialog.EventDialogContext;
import lib.toma.animations.engine.screen.animator.widget.ListView;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class StopAnimationEvent
extends AbstractAnimationEvent {
    private final AnimationType<?> targetType;

    public StopAnimationEvent(AnimationEventType<? extends StopAnimationEvent> type, float target, AnimationType<?> targetType) {
        super(type, target);
        this.targetType = targetType;
    }

    public StopAnimationEvent(float target, AnimationType<?> targetType) {
        this(AnimationEventType.STOP_ANIMATION, target, targetType);
    }

    @Override
    public void dispatch(Minecraft client, IAnimation fromAnimation) {
        IAnimationPipeline pipeline = AnimationEngine.get().pipeline();
        pipeline.remove(this.targetType);
    }

    @Override
    public IAnimationEvent copyAt(float target) {
        return new StopAnimationEvent(target, this.targetType);
    }

    public static class AddStopAnimationEventDialog
    extends EventCreateDialog<StopAnimationEvent> {
        private AnimationType<?> selected;

        public AddStopAnimationEventDialog(EventDialogContext<StopAnimationEvent> context) {
            super(context);
            this.setDimensions(175, 120);
        }

        @Override
        protected void addWidgets() {
            int elWidth = this.dWidth() - 10;
            int btWidth = (elWidth - 5) / 2;
            ListView view = (ListView)this.func_230480_a_(new ListView(this.left() + 5, this.top() + 15, elWidth, 75, Registries.ANIMATION_TYPES.values()));
            view.setResponder(this::onSelect);
            view.setFormatter(type -> type.getKey().toString());
            this.cancel = (Button)this.func_230480_a_((Widget)new Button(this.left() + 5, this.top() + 95, btWidth, 20, CANCEL, this::cancel_clicked));
            this.confirm = (Button)this.func_230480_a_((Widget)new Button(this.left() + 10 + btWidth, this.top() + 95, btWidth, 20, CONFIRM, this::confirm_clicked));
            this.updateConfirmButton();
        }

        @Override
        protected StopAnimationEvent construct() {
            return new StopAnimationEvent(this.getContext().getTarget(), this.selected);
        }

        private void onSelect(AnimationType<?> value) {
            this.selected = value;
            this.updateConfirmButton();
        }

        private void updateConfirmButton() {
            if (this.confirm != null) {
                this.confirm.field_230693_o_ = this.selected != null;
            }
        }
    }

    public static class Serializer
    implements IAnimationEventSerializer<StopAnimationEvent> {
        @Override
        public JsonElement serialize(StopAnimationEvent event, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("key", event.targetType.getKey().toString());
            return object;
        }

        @Override
        public StopAnimationEvent deserialize(float target, JsonElement src, JsonDeserializationContext context) throws JsonParseException {
            if (!src.isJsonObject()) {
                throw new JsonSyntaxException("Not a Json object!");
            }
            JsonObject object = src.getAsJsonObject();
            ResourceLocation keyPath = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"key"));
            AnimationType<?> type = Registries.ANIMATION_TYPES.getElement(keyPath);
            if (type == null) {
                throw new JsonSyntaxException("Unknown animation type: " + keyPath);
            }
            return new StopAnimationEvent(target, type);
        }
    }
}

